export type KYCStatus = 'pending_review' | 'approved' | 'rejected';
export type RegistrationType = 'sole_proprietor' | 'limited_liability' | 'partnership' | 'other';

export interface KYCSubmission {
  id: string;
  vendor_id: string;
  business_name: string;
  registration_type: RegistrationType;
  id_type: string;
  id_number: string;
  id_document_url: string;
  business_document_url?: string;
  status: KYCStatus;
  rejection_reason?: string;
  submitted_at: string;
  reviewed_at?: string;
}

export interface KYCReviewAction {
  action: 'approve' | 'reject';
  rejection_reason?: string;
}

export interface SubmitKYCRequest {
  business_name: string;
  registration_type: RegistrationType;
  id_type: string;
  id_number: string;
  id_document_url: string;
  business_document_url?: string;
} 